/*
 * Decompiled with CFR 0.152.
 */
package plc.transport;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.SocketTimeoutException;
import plc.transport.DatagramTransport;
import plc.transport.exception.CommunicationTimeoutException;

public final class SyncUdpTransport
implements DatagramTransport {
    private final DatagramSocket socket = new DatagramSocket();

    public SyncUdpTransport(int timeout) throws IOException {
        this.socket.setSoTimeout(timeout);
    }

    @Override
    public void send(InetSocketAddress address, byte[] data) throws IOException {
        DatagramPacket requestPacket = new DatagramPacket(data, data.length, address);
        this.socket.send(requestPacket);
    }

    @Override
    public byte[] receive(int responseBufferSize) throws IOException, CommunicationTimeoutException {
        try {
            byte[] buffer = new byte[responseBufferSize];
            DatagramPacket responsePacket = new DatagramPacket(buffer, buffer.length);
            this.socket.receive(responsePacket);
            byte[] actualData = new byte[responsePacket.getLength()];
            System.arraycopy(responsePacket.getData(), responsePacket.getOffset(), actualData, 0, responsePacket.getLength());
            return actualData;
        }
        catch (SocketTimeoutException e) {
            throw new CommunicationTimeoutException("Response timed out", e);
        }
    }

    @Override
    public void close() {
        if (this.socket != null && !this.socket.isClosed()) {
            this.socket.close();
        }
    }
}

