/*
 * Decompiled with CFR 0.152.
 */
package plc.transport;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import plc.transport.StreamTransport;
import plc.transport.exception.CommunicationTimeoutException;

public class SyncTcpTransport
implements StreamTransport {
    private final Socket socket = new Socket();
    private final OutputStream outputStream;
    private final InputStream inputStream;

    @Deprecated
    public SyncTcpTransport(String host, int port) throws IOException {
        this(new InetSocketAddress(host, port), 0);
    }

    @Deprecated
    public SyncTcpTransport(String host, int port, int timeout) throws IOException {
        this(new InetSocketAddress(host, port), timeout);
    }

    public SyncTcpTransport(InetSocketAddress address) throws IOException {
        this(address, 0);
    }

    public SyncTcpTransport(InetSocketAddress address, int timeout) throws IOException {
        this.socket.connect(address, timeout);
        this.socket.setSoTimeout(timeout);
        this.outputStream = this.socket.getOutputStream();
        this.inputStream = this.socket.getInputStream();
    }

    @Override
    public void send(byte[] data) throws IOException {
        this.outputStream.write(data);
        this.outputStream.flush();
    }

    @Override
    public byte[] receive(int bytesToReceive) throws IOException, CommunicationTimeoutException {
        try {
            byte[] receivedData = this.inputStream.readNBytes(bytesToReceive);
            if (receivedData.length < bytesToReceive) {
                throw new IOException("Connection closed prematurely. Expected " + bytesToReceive + " bytes, but only received " + receivedData.length);
            }
            return receivedData;
        }
        catch (SocketTimeoutException e) {
            throw new CommunicationTimeoutException("Receive timed out after " + this.socket.getSoTimeout() + " ms", e);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.socket != null && !this.socket.isClosed()) {
            this.socket.close();
        }
    }
}

