/*
 * Decompiled with CFR 0.152.
 */
package plc.slmp.slmpframe.request;

import java.util.ArrayList;
import java.util.List;
import plc.slmp.slmpframe.Device;
import plc.slmp.slmpframe.data.BitData;
import plc.slmp.slmpframe.data.DWordData;
import plc.slmp.slmpframe.data.DoubleData;
import plc.slmp.slmpframe.data.FloatData;
import plc.slmp.slmpframe.data.PlcData;
import plc.slmp.slmpframe.data.WordData;

public interface WriteRequest {
    public Device getStartDevice();

    public List<PlcData> getData();

    public int getTotalWordCount();

    public static WordWriteRequestBuilder createWordWrite(Device device) {
        return new WordWriteRequestBuilder(device);
    }

    public static BitWriteRequestBuilder createBitWrite(Device device) {
        return new BitWriteRequestBuilder(device);
    }

    public static class WordWriteRequestBuilder
    implements WriteRequest {
        private final Device startDevice;
        private final List<PlcData> data = new ArrayList<PlcData>();
        private int totalWordCount = 0;

        private WordWriteRequestBuilder(Device device) {
            this.startDevice = device;
        }

        public WordWriteRequestBuilder writeWord(int value) {
            this.data.add(new WordData(value));
            ++this.totalWordCount;
            return this;
        }

        public WordWriteRequestBuilder writeWords(List<Integer> values) {
            for (int value : values) {
                this.data.add(new WordData(value));
            }
            this.totalWordCount += values.size();
            return this;
        }

        public WordWriteRequestBuilder writeDWord(int value) {
            this.data.add(new DWordData(value));
            this.totalWordCount += 2;
            return this;
        }

        public WordWriteRequestBuilder writeFloat(float value) {
            this.data.add(new FloatData(value));
            this.totalWordCount += 2;
            return this;
        }

        public WordWriteRequestBuilder writeDouble(double value) {
            this.data.add(new DoubleData(value));
            this.totalWordCount += 4;
            return this;
        }

        public WordWriteRequestBuilder writeAll(List<PlcData> dataList) {
            for (PlcData d : dataList) {
                this.data.add(d);
                this.totalWordCount += d.getWordCount();
            }
            return this;
        }

        @Override
        public Device getStartDevice() {
            return this.startDevice;
        }

        @Override
        public List<PlcData> getData() {
            return this.data;
        }

        @Override
        public int getTotalWordCount() {
            return this.totalWordCount;
        }
    }

    public static class BitWriteRequestBuilder
    implements WriteRequest {
        private final Device startDevice;
        private final List<PlcData> data = new ArrayList<PlcData>();
        private int totalBitCount = 0;

        private BitWriteRequestBuilder(Device device) {
            this.startDevice = device;
        }

        public BitWriteRequestBuilder writeBit(boolean value) {
            this.data.add(new BitData(value));
            ++this.totalBitCount;
            return this;
        }

        public BitWriteRequestBuilder writeBits(List<Boolean> values) {
            for (boolean value : values) {
                this.data.add(new BitData(value));
            }
            this.totalBitCount += values.size();
            return this;
        }

        public BitWriteRequestBuilder writeAll(List<PlcData> dataList) {
            for (PlcData d : dataList) {
                if (!(d instanceof BitData)) {
                    throw new IllegalArgumentException("BitWriteRequestBuilder\u306fBitData\u306e\u307f\u3092\u53d7\u3051\u4ed8\u3051\u307e\u3059\u3002");
                }
                this.data.add(d);
                this.totalBitCount += d.getWordCount();
            }
            return this;
        }

        @Override
        public Device getStartDevice() {
            return this.startDevice;
        }

        @Override
        public List<PlcData> getData() {
            return this.data;
        }

        @Override
        public int getTotalWordCount() {
            return this.totalBitCount;
        }
    }
}

