/*
 * Decompiled with CFR 0.152.
 */
package plc.slmp.slmpframe.request;

import java.util.ArrayList;
import java.util.List;
import plc.slmp.slmpframe.Device;
import plc.slmp.slmpframe.data.DWordData;
import plc.slmp.slmpframe.data.DoubleData;
import plc.slmp.slmpframe.data.FloatData;
import plc.slmp.slmpframe.data.PlcData;
import plc.slmp.slmpframe.data.WordData;

public interface ReadRequest {
    public Device getStartDevice();

    public List<Class<? extends PlcData>> getDataTypes();

    public int getTotalWordCount();

    public static WordReadRequestBuilder createWordRead(Device device) {
        return new WordReadRequestBuilder(device);
    }

    public static BitReadRequestBuilder createBitRead(Device device) {
        return new BitReadRequestBuilder(device);
    }

    public static class WordReadRequestBuilder
    implements ReadRequest {
        private final Device startDevice;
        private final List<Class<? extends PlcData>> dataTypes = new ArrayList<Class<? extends PlcData>>();
        private int totalWordCount = 0;

        private WordReadRequestBuilder(Device device) {
            this.startDevice = device;
        }

        public WordReadRequestBuilder readWord(int count) {
            if (count <= 0) {
                throw new IllegalArgumentException("\u8aad\u51fa\u3057\u70b9\u6570\u306f1\u4ee5\u4e0a\u3067\u3042\u308b\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059\u3002");
            }
            for (int i = 0; i < count; ++i) {
                this.dataTypes.add(WordData.class);
            }
            this.totalWordCount += 1 * count;
            return this;
        }

        public WordReadRequestBuilder readDWord(int count) {
            if (count <= 0) {
                throw new IllegalArgumentException("\u8aad\u51fa\u3057\u70b9\u6570\u306f1\u4ee5\u4e0a\u3067\u3042\u308b\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059\u3002");
            }
            for (int i = 0; i < count; ++i) {
                this.dataTypes.add(DWordData.class);
            }
            this.totalWordCount += 2 * count;
            return this;
        }

        public WordReadRequestBuilder readFloat(int count) {
            if (count <= 0) {
                throw new IllegalArgumentException("\u8aad\u51fa\u3057\u70b9\u6570\u306f1\u4ee5\u4e0a\u3067\u3042\u308b\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059\u3002");
            }
            for (int i = 0; i < count; ++i) {
                this.dataTypes.add(FloatData.class);
            }
            this.totalWordCount += 2 * count;
            return this;
        }

        public WordReadRequestBuilder readDouble(int count) {
            if (count <= 0) {
                throw new IllegalArgumentException("\u8aad\u51fa\u3057\u70b9\u6570\u306f1\u4ee5\u4e0a\u3067\u3042\u308b\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059\u3002");
            }
            for (int i = 0; i < count; ++i) {
                this.dataTypes.add(DoubleData.class);
            }
            this.totalWordCount += 4 * count;
            return this;
        }

        @Override
        public Device getStartDevice() {
            return this.startDevice;
        }

        @Override
        public List<Class<? extends PlcData>> getDataTypes() {
            return this.dataTypes;
        }

        @Override
        public int getTotalWordCount() {
            return this.totalWordCount;
        }
    }

    public static class BitReadRequestBuilder
    implements ReadRequest {
        private final Device startDevice;
        private final List<Class<? extends PlcData>> dataTypes = new ArrayList<Class<? extends PlcData>>();
        private int totalBitCount = 0;

        private BitReadRequestBuilder(Device device) {
            this.startDevice = device;
        }

        public BitReadRequestBuilder readBit(int count) {
            if (count <= 0) {
                throw new IllegalArgumentException("\u8aad\u51fa\u3057\u70b9\u6570\u306f1\u4ee5\u4e0a\u3067\u3042\u308b\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059\u3002");
            }
            for (int i = 0; i < count; ++i) {
                this.dataTypes.add(WordData.class);
            }
            this.totalBitCount += count;
            return this;
        }

        @Override
        public Device getStartDevice() {
            return this.startDevice;
        }

        @Override
        public List<Class<? extends PlcData>> getDataTypes() {
            return this.dataTypes;
        }

        @Override
        public int getTotalWordCount() {
            return this.totalBitCount;
        }
    }
}

