/*
 * Decompiled with CFR 0.152.
 */
package plc.slmp.slmpframe.request;

import java.util.ArrayList;
import java.util.List;
import plc.slmp.slmpframe.Device;
import plc.slmp.slmpframe.data.DWordData;
import plc.slmp.slmpframe.data.WordData;

public interface RandomWriteRequest {
    public List<WordWriteEntry> getWordEntries();

    public List<DWordWriteEntry> getDWordEntries();

    public static RandomWriteRequestBuilder create() {
        return new RandomWriteRequestBuilder();
    }

    public static class RandomWriteRequestBuilder
    implements RandomWriteRequest {
        private final List<WordWriteEntry> wordEntries = new ArrayList<WordWriteEntry>();
        private final List<DWordWriteEntry> dwordEntries = new ArrayList<DWordWriteEntry>();

        private RandomWriteRequestBuilder() {
        }

        public RandomWriteRequestBuilder writeWord(Device device, WordData data) {
            this.wordEntries.add(new WordWriteEntry(device, data));
            return this;
        }

        public RandomWriteRequestBuilder writeDWord(Device device, DWordData data) {
            this.dwordEntries.add(new DWordWriteEntry(device, data));
            return this;
        }

        public RandomWriteRequestBuilder writeAllWords(List<WordWriteEntry> entries) {
            this.wordEntries.addAll(entries);
            return this;
        }

        public RandomWriteRequestBuilder writeAllDWords(List<DWordWriteEntry> entries) {
            this.dwordEntries.addAll(entries);
            return this;
        }

        @Override
        public List<WordWriteEntry> getWordEntries() {
            return List.copyOf(this.wordEntries);
        }

        @Override
        public List<DWordWriteEntry> getDWordEntries() {
            return List.copyOf(this.dwordEntries);
        }
    }

    public record DWordWriteEntry(Device device, DWordData data) {
    }

    public record WordWriteEntry(Device device, WordData data) {
    }
}

