/*
 * Decompiled with CFR 0.152.
 */
package plc.slmp.slmpframe.request;

import java.util.ArrayList;
import java.util.List;
import plc.slmp.slmpframe.Device;

public interface RandomReadRequest {
    public List<Device> getWordDevices();

    public List<Device> getDWordDevices();

    public static RandomReadRequestBuilder create() {
        return new RandomReadRequestBuilder();
    }

    public static class RandomReadRequestBuilder
    implements RandomReadRequest {
        private final List<Device> wordDevices = new ArrayList<Device>();
        private final List<Device> dwordDevices = new ArrayList<Device>();

        private RandomReadRequestBuilder() {
        }

        public RandomReadRequestBuilder readWord(Device device) {
            this.wordDevices.add(device);
            return this;
        }

        public RandomReadRequestBuilder readDWord(Device device) {
            this.dwordDevices.add(device);
            return this;
        }

        public RandomReadRequestBuilder readAllWords(List<Device> devices) {
            this.wordDevices.addAll(devices);
            return this;
        }

        public RandomReadRequestBuilder readAllDWords(List<Device> devices) {
            this.dwordDevices.addAll(devices);
            return this;
        }

        @Override
        public List<Device> getWordDevices() {
            return List.copyOf(this.wordDevices);
        }

        @Override
        public List<Device> getDWordDevices() {
            return List.copyOf(this.dwordDevices);
        }
    }
}

