/*
 * Decompiled with CFR 0.152.
 */
package plc.slmp.slmpframe.error;

import java.util.ArrayList;
import java.util.Optional;
import plc.slmp.slmpframe.error.ErrorInformationProvider;
import plc.slmp.slmpframe.error.SlmpErrorInfo;
import plc.slmp.slmpframe.exception.SlmpErrorCodeException;
import plc.slmp.slmpframe.exception.SlmpErrorCodeRuntimeException;
import plc.slmp.slmpframe.exception.SlmpException;

public class SlmpErrorMessageResolver {
    private final ErrorInformationProvider provider;

    public SlmpErrorMessageResolver(ErrorInformationProvider provider) {
        this.provider = provider;
    }

    public Optional<SlmpErrorInfo> resolve(int endCode) {
        Optional<String> actionOpt;
        String codeHex = String.format("%04X", endCode).toUpperCase();
        Optional<String> descriptionOpt = this.provider.getProperty(codeHex + ".description");
        if (descriptionOpt.isEmpty()) {
            return Optional.empty();
        }
        String type = this.provider.getProperty(codeHex + ".type").orElse(null);
        String supportedFrames = this.provider.getProperty(codeHex + ".supported_frames").orElse(null);
        ArrayList<String> actions = new ArrayList<String>();
        int i = 1;
        while (!(actionOpt = this.provider.getProperty(codeHex + ".action." + i)).isEmpty()) {
            actions.add(actionOpt.get());
            ++i;
        }
        return Optional.of(new SlmpErrorInfo(descriptionOpt.get(), type, actions, supportedFrames));
    }

    public void resolveAndThrow(int endCode) throws SlmpException {
        SlmpErrorInfo errorInfo = this.resolve(endCode).orElseThrow(() -> new IllegalArgumentException("Unknown SLMP end code: " + String.format("0x%04X", endCode)));
        String errorType = errorInfo.type();
        if ("logic".equalsIgnoreCase(errorType)) {
            throw new SlmpErrorCodeRuntimeException(errorInfo);
        }
        if ("user".equalsIgnoreCase(errorType)) {
            throw new SlmpErrorCodeException(errorInfo);
        }
        throw new IllegalStateException(String.format("Invalid or missing error type '%s' in properties for end code 0x%04X", errorType, endCode));
    }

    public void resolveAndThrow(int endCode, Throwable cause) throws SlmpException {
        SlmpErrorInfo errorInfo = this.resolve(endCode).orElseThrow(() -> new IllegalArgumentException("Unknown SLMP end code: " + String.format("0x%04X", endCode), cause));
        String errorType = errorInfo.type();
        if ("logic".equalsIgnoreCase(errorType)) {
            throw new SlmpErrorCodeRuntimeException(errorInfo, cause);
        }
        if ("user".equalsIgnoreCase(errorType)) {
            throw new SlmpErrorCodeException(errorInfo, cause);
        }
        throw new IllegalStateException(String.format("Invalid or missing error type '%s' in properties for end code 0x%04X", errorType, endCode), cause);
    }
}

