/*
 * Decompiled with CFR 0.152.
 */
package plc.slmp.slmpframe.e3.calculator;

import java.util.Map;
import java.util.Optional;
import plc.slmp.slmpframe.ResponseFrameSizeInfo;
import plc.slmp.slmpframe.SlmpCommandCode;
import plc.slmp.slmpframe.SlmpFrame;
import plc.slmp.slmpframe.SlmpResponseSizeCalculator;
import plc.slmp.slmpframe.e3.calculator.RandomReadCommandSizeStrategy;
import plc.slmp.slmpframe.e3.calculator.RandomWriteCommandSizeStrategy;
import plc.slmp.slmpframe.e3.calculator.ReadCommandSizeStrategy;
import plc.slmp.slmpframe.e3.calculator.ResponseSizeCalculationStrategy;
import plc.slmp.slmpframe.e3.calculator.WriteCommandSizeStrategy;

public class Slmp3eResponseSizeCalculator
implements SlmpResponseSizeCalculator {
    private static final int ERROR_RESPONSE_TOTAL_LENGTH = 20;
    private static final Map<Integer, ResponseSizeCalculationStrategy> STRATEGIES = Map.of(SlmpCommandCode.READ.getCode(), new ReadCommandSizeStrategy(), SlmpCommandCode.WRITE.getCode(), new WriteCommandSizeStrategy(), SlmpCommandCode.RANDOM_WRITE.getCode(), new RandomWriteCommandSizeStrategy(), SlmpCommandCode.RANDOM_READ.getCode(), new RandomReadCommandSizeStrategy());

    @Override
    public ResponseFrameSizeInfo calculate(SlmpFrame requestFrame) {
        int normalTotalLength = this.calculateNormalTotalLength(requestFrame);
        int headerLength = 11;
        return new ResponseFrameSizeInfo(normalTotalLength, 20, 11);
    }

    @Override
    public int getFixedHeaderSize() {
        return 11;
    }

    private int calculateNormalTotalLength(SlmpFrame requestFrame) {
        int commandCode = requestFrame.getCommand().getCommand();
        return Optional.ofNullable(STRATEGIES.get(commandCode)).map(strategy -> strategy.calculate(requestFrame)).orElseThrow(() -> new IllegalArgumentException("Unsupported command for size calculation: " + commandCode));
    }
}

