/*
 * Decompiled with CFR 0.152.
 */
package plc.slmp.slmpframe.e3.calculator;

import plc.slmp.slmpframe.SlmpFrame;
import plc.slmp.slmpframe.e3.calculator.ResponseSizeCalculationStrategy;
import plc.slmp.slmpframe.payload.BitDeviceReadPayload;
import plc.slmp.slmpframe.payload.CommandPayload;
import plc.slmp.slmpframe.payload.WordDeviceReadPayload;

public class ReadCommandSizeStrategy
implements ResponseSizeCalculationStrategy {
    @Override
    public int calculate(SlmpFrame requestFrame) {
        int responseDataLength;
        CommandPayload payload = requestFrame.getCommand().getPayload();
        if (payload instanceof WordDeviceReadPayload) {
            WordDeviceReadPayload p = (WordDeviceReadPayload)payload;
            responseDataLength = p.getCount().value() * 2;
        } else if (payload instanceof BitDeviceReadPayload) {
            BitDeviceReadPayload p = (BitDeviceReadPayload)payload;
            responseDataLength = (p.getCount().value() + 1) / 2;
        } else {
            throw new IllegalArgumentException("Unsupported Payload type for ReadCommand: " + payload.getClass().getName());
        }
        return 11 + responseDataLength;
    }
}

