/*
 * Decompiled with CFR 0.152.
 */
package plc.slmp.slmpframe.e3;

import java.util.List;
import plc.slmp.serializer.Slmp3eBinaryFrameSerializer;
import plc.slmp.serializer.SlmpFrameSerializer;
import plc.slmp.slmpframe.Device;
import plc.slmp.slmpframe.DeviceCount;
import plc.slmp.slmpframe.SlmpCommand;
import plc.slmp.slmpframe.SlmpCommandCode;
import plc.slmp.slmpframe.SlmpFactory;
import plc.slmp.slmpframe.SlmpFrame;
import plc.slmp.slmpframe.SlmpHeader;
import plc.slmp.slmpframe.SlmpResponseSizeCalculator;
import plc.slmp.slmpframe.data.PlcData;
import plc.slmp.slmpframe.e3.Slmp3eCommand;
import plc.slmp.slmpframe.e3.Slmp3eFrame;
import plc.slmp.slmpframe.e3.Slmp3eRequestHeader;
import plc.slmp.slmpframe.e3.calculator.Slmp3eResponseSizeCalculator;
import plc.slmp.slmpframe.payload.BitDeviceReadPayload;
import plc.slmp.slmpframe.payload.BitDeviceWritePayload;
import plc.slmp.slmpframe.payload.CommandPayload;
import plc.slmp.slmpframe.payload.RandomReadPayload;
import plc.slmp.slmpframe.payload.RandomWordWritePayload;
import plc.slmp.slmpframe.payload.WordDeviceReadPayload;
import plc.slmp.slmpframe.payload.WordDeviceWritePayload;
import plc.slmp.slmpframe.request.RandomReadRequest;
import plc.slmp.slmpframe.request.RandomWriteRequest;
import plc.slmp.slmpframe.request.ReadRequest;
import plc.slmp.slmpframe.request.WriteRequest;

public class Slmp3eFactory
implements SlmpFactory {
    @Override
    public SlmpHeader createHeaderWithDefaults() {
        return Slmp3eRequestHeader.createWithDefaults();
    }

    @Override
    public SlmpHeader createHeaderWithCustomParameters(int networkNumber, int stationNumber, int moduleIoNumber, int multidropStationNumber, int monitoringTimer) {
        return Slmp3eRequestHeader.createWithCustomParameters(networkNumber, stationNumber, moduleIoNumber, multidropStationNumber, monitoringTimer);
    }

    @Override
    public SlmpFrame createFrame(SlmpHeader header, SlmpCommand command) {
        return new Slmp3eFrame(header, command);
    }

    @Override
    public SlmpCommand createReadCommand(ReadRequest request) {
        CommandPayload payload;
        Device device = request.getStartDevice();
        DeviceCount count = new DeviceCount(request.getTotalWordCount());
        if (request instanceof ReadRequest.WordReadRequestBuilder) {
            payload = new WordDeviceReadPayload(device, count, request.getDataTypes());
        } else if (request instanceof ReadRequest.BitReadRequestBuilder) {
            payload = new BitDeviceReadPayload(device, count);
        } else {
            throw new IllegalArgumentException("Unsupported ReadRequest type: " + request.getClass().getName());
        }
        return new Slmp3eCommand(SlmpCommandCode.READ, payload);
    }

    @Override
    public SlmpCommand createWriteCommand(WriteRequest request) {
        CommandPayload payload;
        Device device = request.getStartDevice();
        List<PlcData> data = request.getData();
        if (request instanceof WriteRequest.WordWriteRequestBuilder) {
            payload = new WordDeviceWritePayload(device, data);
        } else if (request instanceof WriteRequest.BitWriteRequestBuilder) {
            payload = new BitDeviceWritePayload(device, data);
        } else {
            throw new IllegalArgumentException("Unsupported WriteRequest type: " + request.getClass().getName());
        }
        return new Slmp3eCommand(SlmpCommandCode.WRITE, payload);
    }

    @Override
    public SlmpCommand createRandomWriteCommand(RandomWriteRequest request) {
        RandomWordWritePayload payload = new RandomWordWritePayload(request);
        return new Slmp3eCommand(SlmpCommandCode.RANDOM_WRITE, payload);
    }

    @Override
    public SlmpCommand createRandomReadCommand(RandomReadRequest request) {
        RandomReadPayload payload = new RandomReadPayload(request);
        return new Slmp3eCommand(SlmpCommandCode.RANDOM_READ, payload);
    }

    @Override
    public SlmpFrameSerializer createSerializer() {
        return new Slmp3eBinaryFrameSerializer();
    }

    @Override
    public SlmpResponseSizeCalculator createResponseSizeCalculator() {
        return new Slmp3eResponseSizeCalculator();
    }
}

