/*
 * Decompiled with CFR 0.152.
 */
package plc.slmp.slmpframe;

import plc.slmp.serializer.SlmpFrameSerializer;
import plc.slmp.slmpframe.SlmpCommand;
import plc.slmp.slmpframe.SlmpFrame;
import plc.slmp.slmpframe.SlmpFrameType;
import plc.slmp.slmpframe.SlmpHeader;
import plc.slmp.slmpframe.SlmpResponseSizeCalculator;
import plc.slmp.slmpframe.e3.Slmp3eFactory;
import plc.slmp.slmpframe.request.RandomReadRequest;
import plc.slmp.slmpframe.request.RandomWriteRequest;
import plc.slmp.slmpframe.request.ReadRequest;
import plc.slmp.slmpframe.request.WriteRequest;

public interface SlmpFactory {
    public static SlmpFactory of(SlmpFrameType frameType) {
        switch (frameType) {
            case TYPE_3E: {
                return new Slmp3eFactory();
            }
        }
        throw new IllegalArgumentException("Unsupported frame type: " + String.valueOf((Object)frameType));
    }

    public SlmpHeader createHeaderWithDefaults();

    public SlmpHeader createHeaderWithCustomParameters(int var1, int var2, int var3, int var4, int var5);

    public SlmpFrame createFrame(SlmpHeader var1, SlmpCommand var2);

    public SlmpCommand createReadCommand(ReadRequest var1);

    public SlmpCommand createWriteCommand(WriteRequest var1);

    public SlmpCommand createRandomWriteCommand(RandomWriteRequest var1);

    public SlmpCommand createRandomReadCommand(RandomReadRequest var1);

    public SlmpFrameSerializer createSerializer();

    public SlmpResponseSizeCalculator createResponseSizeCalculator();
}

