/*
 * Decompiled with CFR 0.152.
 */
package plc.slmp.serializer;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;
import plc.slmp.serializer.SlmpFrameSerializer;
import plc.slmp.slmpframe.Device;
import plc.slmp.slmpframe.SlmpCommand;
import plc.slmp.slmpframe.SlmpCommandCode;
import plc.slmp.slmpframe.SlmpFrame;
import plc.slmp.slmpframe.SlmpFrameResponse;
import plc.slmp.slmpframe.SlmpHeader;
import plc.slmp.slmpframe.data.BitData;
import plc.slmp.slmpframe.data.DWordData;
import plc.slmp.slmpframe.data.PlcData;
import plc.slmp.slmpframe.data.WordData;
import plc.slmp.slmpframe.e3.Slmp3eResponse;
import plc.slmp.slmpframe.e3.Slmp3eResponseHeader;
import plc.slmp.slmpframe.exception.SlmpMalformedResponseException;
import plc.slmp.slmpframe.exception.SlmpResponseException;
import plc.slmp.slmpframe.payload.BitDeviceReadPayload;
import plc.slmp.slmpframe.payload.BitDeviceWritePayload;
import plc.slmp.slmpframe.payload.CommandPayload;
import plc.slmp.slmpframe.payload.RandomReadPayload;
import plc.slmp.slmpframe.payload.RandomWordWritePayload;
import plc.slmp.slmpframe.payload.WordDeviceReadPayload;
import plc.slmp.slmpframe.payload.WordDeviceWritePayload;
import plc.slmp.slmpframe.request.RandomReadRequest;
import plc.slmp.slmpframe.request.RandomWriteRequest;

public class Slmp3eBinaryFrameSerializer
implements SlmpFrameSerializer {
    private static final int SLMP_3E_HEADER_LENGTH = 11;
    private static final int SLMP_3E_COMMAND_LENGTH = 4;

    @Override
    public byte[] serialize(SlmpFrame frame) {
        SlmpHeader header = frame.getHeader();
        SlmpCommand command = frame.getCommand();
        CommandPayload payload = command.getPayload();
        int payloadLength = this.calculatePayloadLength(payload);
        int dataLengthFieldValue = 6 + payloadLength;
        int totalFrameLength = 15 + payloadLength;
        ByteBuffer buffer = ByteBuffer.allocate(totalFrameLength).order(ByteOrder.LITTLE_ENDIAN);
        this.writeHeader(buffer, header, dataLengthFieldValue);
        buffer.putShort((short)command.getCommand());
        buffer.putShort((short)command.getSubcommand());
        this.writePayload(buffer, payload);
        return buffer.array();
    }

    @Override
    public SlmpFrameResponse deserialize(byte[] responseBytes, SlmpFrame requestFrame) throws SlmpResponseException {
        ArrayList<PlcData> responseData;
        Slmp3eResponseHeader responseHeader;
        int endCode;
        block8: {
            CommandPayload requestPayload;
            SlmpCommand requestCommand;
            ByteBuffer buffer;
            block9: {
                block10: {
                    int responseFixedLength = 11;
                    if (responseBytes.length < 11) {
                        throw new SlmpMalformedResponseException("\u5fdc\u7b54\u30d0\u30a4\u30c8\u914d\u5217\u306e\u9577\u3055\u304c\u56fa\u5b9a\u9577(11\u30d0\u30a4\u30c8)\u306b\u6e80\u305f\u306a\u3044\u305f\u3081\u3001\u89e3\u6790\u3067\u304d\u307e\u305b\u3093\u3002");
                    }
                    buffer = ByteBuffer.wrap(responseBytes);
                    buffer.order(ByteOrder.BIG_ENDIAN);
                    int subheader = buffer.getShort() & 0xFFFF;
                    buffer.order(ByteOrder.LITTLE_ENDIAN);
                    int networkNo = buffer.get() & 0xFF;
                    int stationNo = buffer.get() & 0xFF;
                    int unitIoNo = buffer.getShort() & 0xFFFF;
                    int multidropStationNo = buffer.get() & 0xFF;
                    int responseDataLength = buffer.getShort() & 0xFFFF;
                    endCode = buffer.getShort() & 0xFFFF;
                    if (subheader != 53248) {
                        throw new SlmpMalformedResponseException("\u4e0d\u6b63\u306aSLMP 3E\u5fdc\u7b54\u30b5\u30d6\u30d8\u30c3\u30c0\u3067\u3059\u3002\u671f\u5f85\u5024: 0xD000, \u5b9f\u969b\u5024: " + String.format("0x%04X", subheader));
                    }
                    int actualDataPartLength = responseBytes.length - 11;
                    if (actualDataPartLength != responseDataLength - 2) {
                        throw new SlmpMalformedResponseException("\u5fdc\u7b54\u30c7\u30fc\u30bf\u9577\u304c\u4e00\u81f4\u3057\u307e\u305b\u3093\u3002\u30d8\u30c3\u30c0\u5185\u306e\u30c7\u30fc\u30bf\u9577: " + (responseDataLength - 2) + ", \u5b9f\u969b\u306e\u30c7\u30fc\u30bf\u9577: " + actualDataPartLength);
                    }
                    responseHeader = new Slmp3eResponseHeader(subheader, networkNo, stationNo, unitIoNo, multidropStationNo);
                    responseData = new ArrayList<PlcData>();
                    if (endCode != 0 || actualDataPartLength <= 0) break block8;
                    requestCommand = requestFrame.getCommand();
                    requestPayload = requestCommand.getPayload();
                    if (requestCommand.getCommand() != SlmpCommandCode.READ.getCode()) break block9;
                    if (!(requestPayload instanceof WordDeviceReadPayload)) break block10;
                    WordDeviceReadPayload p = (WordDeviceReadPayload)requestPayload;
                    List<Class<? extends PlcData>> dataTypes = p.getDataTypes();
                    for (Class<? extends PlcData> type : dataTypes) {
                        if (type.equals(WordData.class)) {
                            responseData.add(new WordData(buffer.getShort() & 0xFFFF));
                            continue;
                        }
                        if (!type.equals(DWordData.class)) continue;
                        responseData.add(new DWordData(buffer.getInt()));
                    }
                    break block8;
                }
                if (!(requestPayload instanceof BitDeviceReadPayload)) break block8;
                BitDeviceReadPayload p = (BitDeviceReadPayload)requestPayload;
                responseData.addAll(this.parseBitPlcData(buffer, p.getCount().value()));
                break block8;
            }
            if (requestCommand.getCommand() == SlmpCommandCode.RANDOM_READ.getCode() && requestPayload instanceof RandomReadPayload) {
                int i;
                RandomReadPayload p = (RandomReadPayload)requestPayload;
                int wordCount = p.getRequest().getWordDevices().size();
                int dwordCount = p.getRequest().getDWordDevices().size();
                for (i = 0; i < wordCount; ++i) {
                    responseData.add(new WordData(buffer.getShort() & 0xFFFF));
                }
                for (i = 0; i < dwordCount; ++i) {
                    responseData.add(new DWordData(buffer.getInt()));
                }
            }
        }
        return new Slmp3eResponse(responseHeader, endCode, responseData);
    }

    private void writeHeader(ByteBuffer buffer, SlmpHeader header, int dataLength) {
        buffer.order(ByteOrder.BIG_ENDIAN);
        buffer.putShort((short)20480);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        buffer.put((byte)header.getNetworkNumber());
        buffer.put((byte)header.getStationNumber());
        buffer.putShort((short)header.getModuleIoNumber());
        buffer.put((byte)header.getMultidropStationNumber());
        buffer.putShort((short)dataLength);
        buffer.putShort((short)header.getMonitoringTimer());
    }

    private int calculatePayloadLength(CommandPayload payload) {
        if (payload instanceof WordDeviceReadPayload || payload instanceof BitDeviceReadPayload) {
            return 6;
        }
        if (payload instanceof WordDeviceWritePayload) {
            WordDeviceWritePayload p = (WordDeviceWritePayload)payload;
            int dataSize = p.getData().stream().mapToInt(PlcData::getWordCount).sum() * 2;
            return 6 + dataSize;
        }
        if (payload instanceof BitDeviceWritePayload) {
            BitDeviceWritePayload p = (BitDeviceWritePayload)payload;
            int dataSize = (p.getData().size() + 1) / 2;
            return 6 + dataSize;
        }
        if (payload instanceof RandomReadPayload) {
            RandomReadPayload p = (RandomReadPayload)payload;
            int wordCount = p.getRequest().getWordDevices().size();
            int dwordCount = p.getRequest().getDWordDevices().size();
            return 2 + wordCount * 4 + dwordCount * 4;
        }
        if (payload instanceof RandomWordWritePayload) {
            RandomWordWritePayload p = (RandomWordWritePayload)payload;
            int wordCount = p.getRequest().getWordEntries().size();
            int dwordCount = p.getRequest().getDWordEntries().size();
            return 2 + wordCount * 6 + dwordCount * 8;
        }
        throw new IllegalArgumentException("Unsupported CommandPayload type: " + payload.getClass().getName());
    }

    private void writePayload(ByteBuffer buffer, CommandPayload payload) {
        if (payload instanceof WordDeviceReadPayload) {
            WordDeviceReadPayload p = (WordDeviceReadPayload)payload;
            this.writeDeviceAddressAndCode(buffer, p.getDevice());
            buffer.putShort((short)p.getCount().value());
        } else if (payload instanceof BitDeviceReadPayload) {
            BitDeviceReadPayload p = (BitDeviceReadPayload)payload;
            this.writeDeviceAddressAndCode(buffer, p.getDevice());
            buffer.putShort((short)p.getCount().value());
        } else if (payload instanceof WordDeviceWritePayload) {
            WordDeviceWritePayload p = (WordDeviceWritePayload)payload;
            this.writeDeviceAddressAndCode(buffer, p.getDevice());
            buffer.putShort((short)p.getData().stream().mapToInt(PlcData::getWordCount).sum());
            for (PlcData plcData : p.getData()) {
                for (int word : plcData.toWords()) {
                    buffer.putShort((short)word);
                }
            }
        } else if (payload instanceof BitDeviceWritePayload) {
            BitDeviceWritePayload p = (BitDeviceWritePayload)payload;
            this.writeDeviceAddressAndCode(buffer, p.getDevice());
            buffer.putShort((short)p.getData().size());
            for (int i = 0; i < p.getData().size(); i += 2) {
                BitData bd1;
                PlcData plcData = p.getData().get(i);
                int val1 = plcData instanceof BitData && (bd1 = (BitData)plcData).value() ? 1 : 0;
                int val2 = 0;
                if (i + 1 < p.getData().size()) {
                    BitData bd2;
                    PlcData plcData2 = p.getData().get(i + 1);
                    val2 = plcData2 instanceof BitData && (bd2 = (BitData)plcData2).value() ? 1 : 0;
                }
                byte packedByte = (byte)(val1 << 4 | val2);
                buffer.put(packedByte);
            }
        } else if (payload instanceof RandomReadPayload) {
            RandomReadPayload p = (RandomReadPayload)payload;
            this.writeRandomReadPayload(buffer, p);
        } else if (payload instanceof RandomWordWritePayload) {
            RandomWordWritePayload p = (RandomWordWritePayload)payload;
            this.writeRandomWordWritePayload(buffer, p);
        } else {
            throw new IllegalArgumentException("Unsupported CommandPayload type: " + payload.getClass().getName());
        }
    }

    private void writeDeviceAddressAndCode(ByteBuffer buffer, Device device) {
        buffer.put((byte)device.address().value());
        buffer.putShort((short)(device.address().value() >> 8));
        buffer.put((byte)device.deviceType().getCode());
    }

    private void writeRandomReadPayload(ByteBuffer buffer, RandomReadPayload payload) {
        RandomReadRequest request = payload.getRequest();
        buffer.put((byte)request.getWordDevices().size());
        buffer.put((byte)request.getDWordDevices().size());
        for (Device device : request.getWordDevices()) {
            this.writeDeviceAddressAndCode(buffer, device);
        }
        for (Device device : request.getDWordDevices()) {
            this.writeDeviceAddressAndCode(buffer, device);
        }
    }

    private void writeRandomWordWritePayload(ByteBuffer buffer, RandomWordWritePayload payload) {
        RandomWriteRequest request = payload.getRequest();
        buffer.put((byte)request.getWordEntries().size());
        buffer.put((byte)request.getDWordEntries().size());
        for (RandomWriteRequest.WordWriteEntry wordWriteEntry : request.getWordEntries()) {
            this.writeDeviceAddressAndCode(buffer, wordWriteEntry.device());
            buffer.putShort((short)wordWriteEntry.data().value());
        }
        for (RandomWriteRequest.DWordWriteEntry dWordWriteEntry : request.getDWordEntries()) {
            this.writeDeviceAddressAndCode(buffer, dWordWriteEntry.device());
            buffer.putInt(dWordWriteEntry.data().value());
        }
    }

    private List<PlcData> parseBitPlcData(ByteBuffer buffer, int points) {
        ArrayList<PlcData> result = new ArrayList<PlcData>();
        int bitsRead = 0;
        while (buffer.hasRemaining() && bitsRead < points) {
            byte dataByte = buffer.get();
            result.add(new BitData((dataByte >> 0 & 0xF) == 1));
            if (++bitsRead >= points) continue;
            result.add(new BitData((dataByte >> 4 & 0xF) == 1));
            ++bitsRead;
        }
        return result;
    }
}

