/*
 * Decompiled with CFR 0.152.
 */
package plc.slmp.handler;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Objects;
import plc.slmp.handler.ProtocolHandler;
import plc.slmp.serializer.SlmpFrameSerializer;
import plc.slmp.slmpframe.ResponseFrameSizeInfo;
import plc.slmp.slmpframe.SlmpFrame;
import plc.slmp.slmpframe.SlmpFrameResponse;
import plc.slmp.slmpframe.SlmpResponseSizeCalculator;
import plc.slmp.slmpframe.error.PropertiesFileErrorInformationProvider;
import plc.slmp.slmpframe.error.SlmpErrorMessageResolver;
import plc.slmp.slmpframe.exception.SlmpException;
import plc.transport.DatagramTransport;
import plc.transport.exception.CommunicationTimeoutException;

public final class UdpProtocolHandler
implements ProtocolHandler {
    private final DatagramTransport transport;
    private final SlmpFrameSerializer serializer;
    private final SlmpResponseSizeCalculator sizeCalculator;
    private final InetSocketAddress address;

    public UdpProtocolHandler(DatagramTransport transport, SlmpFrameSerializer serializer, SlmpResponseSizeCalculator sizeCalculator, InetSocketAddress address) {
        this.transport = Objects.requireNonNull(transport, "Transport cannot be null");
        this.serializer = Objects.requireNonNull(serializer, "Serializer cannot be null");
        this.sizeCalculator = Objects.requireNonNull(sizeCalculator, "Size calculator cannot be null");
        this.address = Objects.requireNonNull(address, "Address cannot be null");
    }

    @Override
    public SlmpFrameResponse sendAndReceive(SlmpFrame frame) throws IOException, CommunicationTimeoutException, SlmpException {
        byte[] requestBytes = this.serializer.serialize(frame);
        ResponseFrameSizeInfo info = this.sizeCalculator.calculate(frame);
        int responseBufferSize = Math.max(info.normalTotalLength(), info.errorTotalLength());
        this.transport.send(this.address, requestBytes);
        byte[] responseBytes = this.transport.receive(responseBufferSize);
        SlmpFrameResponse response = this.serializer.deserialize(responseBytes, frame);
        int endCode = response.getRawEndCode();
        if (endCode != 0) {
            PropertiesFileErrorInformationProvider provider = new PropertiesFileErrorInformationProvider("/slmp_errors.properties");
            SlmpErrorMessageResolver resolver = new SlmpErrorMessageResolver(provider);
            resolver.resolveAndThrow(endCode);
        }
        return response;
    }

    @Override
    public void close() throws IOException {
        this.transport.close();
    }
}

