/*
 * Decompiled with CFR 0.152.
 */
package plc.slmp.handler;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import plc.slmp.handler.ProtocolHandler;
import plc.slmp.serializer.SlmpFrameSerializer;
import plc.slmp.slmpframe.SlmpFrame;
import plc.slmp.slmpframe.SlmpFrameResponse;
import plc.slmp.slmpframe.SlmpResponseSizeCalculator;
import plc.slmp.slmpframe.error.PropertiesFileErrorInformationProvider;
import plc.slmp.slmpframe.error.SlmpErrorMessageResolver;
import plc.slmp.slmpframe.exception.SlmpException;
import plc.transport.StreamTransport;
import plc.transport.exception.CommunicationTimeoutException;

public class TcpProtocolHandler
implements ProtocolHandler {
    private final StreamTransport transport;
    private final SlmpFrameSerializer serializer;
    private final SlmpResponseSizeCalculator sizeCalculator;

    public TcpProtocolHandler(StreamTransport transport, SlmpFrameSerializer serializer, SlmpResponseSizeCalculator sizeCalculator) {
        this.transport = transport;
        this.serializer = serializer;
        this.sizeCalculator = sizeCalculator;
    }

    @Override
    public SlmpFrameResponse sendAndReceive(SlmpFrame frame) throws IOException, CommunicationTimeoutException, SlmpException {
        byte[] requestBytes = this.serializer.serialize(frame);
        this.transport.send(requestBytes);
        byte[] headerBytes = this.transport.receive(this.sizeCalculator.getFixedHeaderSize());
        short responseDataLength = ByteBuffer.wrap(headerBytes, 7, 2).order(ByteOrder.LITTLE_ENDIAN).getShort();
        int remainingDataLength = responseDataLength - 2;
        byte[] dataBytes = this.transport.receive(remainingDataLength);
        byte[] fullResponseBytes = new byte[headerBytes.length + dataBytes.length];
        System.arraycopy(headerBytes, 0, fullResponseBytes, 0, headerBytes.length);
        System.arraycopy(dataBytes, 0, fullResponseBytes, headerBytes.length, dataBytes.length);
        SlmpFrameResponse response = this.serializer.deserialize(fullResponseBytes, frame);
        int endCode = response.getRawEndCode();
        if (endCode != 0) {
            PropertiesFileErrorInformationProvider provider = new PropertiesFileErrorInformationProvider("/slmp_errors.properties");
            SlmpErrorMessageResolver resolver = new SlmpErrorMessageResolver(provider);
            resolver.resolveAndThrow(endCode);
        }
        return response;
    }

    @Override
    public void close() throws IOException {
        if (this.transport != null) {
            this.transport.close();
        }
    }
}

