/*
 * Decompiled with CFR 0.152.
 */
package plc.slmp.client.body;

import java.util.HashMap;
import java.util.List;
import plc.slmp.client.body.BodyHandler;
import plc.slmp.slmpframe.Device;
import plc.slmp.slmpframe.data.DWordData;
import plc.slmp.slmpframe.data.PlcData;
import plc.slmp.slmpframe.data.WordData;
import plc.slmp.slmpframe.request.RandomReadRequest;
import plc.slmp.slmpframe.response.RandomReadResponse;

public final class BodyHandlers {
    private BodyHandlers() {
    }

    public static BodyHandler<List<PlcData>> ofPlcData() {
        return response -> response.getResponseData();
    }

    public static BodyHandler<Void> ofDiscarding() {
        return response -> null;
    }

    public static BodyHandler<String> ofString() {
        return response -> response.getResponseData().toString();
    }

    public static BodyHandler<RandomReadResponse> ofRandomRead(RandomReadRequest request) {
        return responseFrame -> {
            List<PlcData> data = responseFrame.getResponseData();
            List<Device> wordDevices = request.getWordDevices();
            List<Device> dwordDevices = request.getDWordDevices();
            HashMap<Device, WordData> wordMap = new HashMap<Device, WordData>();
            HashMap<Device, DWordData> dwordMap = new HashMap<Device, DWordData>();
            int dataIndex = 0;
            for (Device dev : wordDevices) {
                if (dataIndex >= data.size() || !(data.get(dataIndex) instanceof WordData)) continue;
                wordMap.put(dev, (WordData)data.get(dataIndex++));
            }
            for (Device dev : dwordDevices) {
                if (dataIndex >= data.size() || !(data.get(dataIndex) instanceof DWordData)) continue;
                dwordMap.put(dev, (DWordData)data.get(dataIndex++));
            }
            return new RandomReadResponse(wordMap, dwordMap);
        };
    }
}

