/*
 * Decompiled with CFR 0.152.
 */
package plc.slmp.client;

import java.io.Closeable;
import java.io.IOException;
import plc.slmp.client.DefaultSlmpClient;
import plc.slmp.client.body.BodyHandler;
import plc.slmp.client.response.SlmpResponse;
import plc.slmp.slmpframe.SlmpFactory;
import plc.slmp.slmpframe.exception.SlmpException;
import plc.slmp.slmpframe.request.RandomReadRequest;
import plc.slmp.slmpframe.request.RandomWriteRequest;
import plc.slmp.slmpframe.request.ReadRequest;
import plc.slmp.slmpframe.request.WriteRequest;
import plc.transport.DatagramTransport;
import plc.transport.StreamTransport;
import plc.transport.exception.CommunicationTimeoutException;

public interface SlmpClient
extends Closeable {
    public static Builder builder() {
        return new DefaultSlmpClient.DefaultBuilder();
    }

    public <T> SlmpResponse<T> read(ReadRequest var1, BodyHandler<T> var2) throws IOException, InterruptedException, CommunicationTimeoutException, SlmpException;

    public <T> SlmpResponse<T> write(WriteRequest var1, BodyHandler<T> var2) throws IOException, InterruptedException, CommunicationTimeoutException, SlmpException;

    public <T> SlmpResponse<T> write(RandomWriteRequest var1, BodyHandler<T> var2) throws IOException, InterruptedException, CommunicationTimeoutException, SlmpException;

    public <T> SlmpResponse<T> randomRead(RandomReadRequest var1, BodyHandler<T> var2) throws IOException, InterruptedException, CommunicationTimeoutException, SlmpException;

    @Override
    public void close() throws IOException;

    public static interface Builder {
        public Builder udp(String var1, int var2);

        public Builder tcp(String var1, int var2);

        public Builder transport(StreamTransport var1);

        public Builder transport(DatagramTransport var1);

        public Builder timeout(int var1);

        public Builder factory(SlmpFactory var1);

        public SlmpClient build();
    }
}

