/*
 * Decompiled with CFR 0.152.
 */
package plc.slmp.client;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.InetSocketAddress;
import java.util.Objects;
import plc.slmp.client.SlmpClient;
import plc.slmp.client.body.BodyHandler;
import plc.slmp.client.response.SlmpResponse;
import plc.slmp.handler.ProtocolHandler;
import plc.slmp.handler.TcpProtocolHandler;
import plc.slmp.handler.UdpProtocolHandler;
import plc.slmp.serializer.SlmpFrameSerializer;
import plc.slmp.slmpframe.SlmpCommand;
import plc.slmp.slmpframe.SlmpFactory;
import plc.slmp.slmpframe.SlmpFrame;
import plc.slmp.slmpframe.SlmpFrameResponse;
import plc.slmp.slmpframe.SlmpHeader;
import plc.slmp.slmpframe.SlmpResponseSizeCalculator;
import plc.slmp.slmpframe.exception.SlmpException;
import plc.slmp.slmpframe.request.RandomReadRequest;
import plc.slmp.slmpframe.request.RandomWriteRequest;
import plc.slmp.slmpframe.request.ReadRequest;
import plc.slmp.slmpframe.request.WriteRequest;
import plc.transport.DatagramTransport;
import plc.transport.StreamTransport;
import plc.transport.SyncTcpTransport;
import plc.transport.SyncUdpTransport;
import plc.transport.exception.CommunicationTimeoutException;

public final class DefaultSlmpClient
implements SlmpClient {
    private final ProtocolHandler handler;
    private final SlmpFactory factory;

    DefaultSlmpClient(ProtocolHandler handler, SlmpFactory factory) {
        this.handler = handler;
        this.factory = factory;
    }

    @Override
    public <T> SlmpResponse<T> read(ReadRequest request, BodyHandler<T> bodyHandler) throws IOException, InterruptedException, CommunicationTimeoutException, SlmpException {
        SlmpFrame frame = this.createFrame(request);
        SlmpFrameResponse frameResponse = this.handler.sendAndReceive(frame);
        T body = bodyHandler.apply(frameResponse);
        return SlmpResponse.of(frameResponse.getRawEndCode(), body);
    }

    @Override
    public <T> SlmpResponse<T> write(WriteRequest request, BodyHandler<T> bodyHandler) throws IOException, InterruptedException, CommunicationTimeoutException, SlmpException {
        SlmpFrame frame = this.createFrame(request);
        SlmpFrameResponse frameResponse = this.handler.sendAndReceive(frame);
        T body = bodyHandler.apply(frameResponse);
        return SlmpResponse.of(frameResponse.getRawEndCode(), body);
    }

    @Override
    public <T> SlmpResponse<T> write(RandomWriteRequest request, BodyHandler<T> bodyHandler) throws IOException, InterruptedException, CommunicationTimeoutException, SlmpException {
        SlmpFrame frame = this.createFrame(request);
        SlmpFrameResponse frameResponse = this.handler.sendAndReceive(frame);
        T body = bodyHandler.apply(frameResponse);
        return SlmpResponse.of(frameResponse.getRawEndCode(), body);
    }

    @Override
    public <T> SlmpResponse<T> randomRead(RandomReadRequest request, BodyHandler<T> bodyHandler) throws IOException, InterruptedException, CommunicationTimeoutException, SlmpException {
        SlmpFrame frame = this.createFrame(request);
        SlmpFrameResponse frameResponse = this.handler.sendAndReceive(frame);
        T body = bodyHandler.apply(frameResponse);
        return SlmpResponse.of(frameResponse.getRawEndCode(), body);
    }

    private SlmpFrame createFrame(Object request) {
        SlmpCommand command;
        SlmpHeader header = this.factory.createHeaderWithDefaults();
        if (request instanceof ReadRequest) {
            command = this.factory.createReadCommand((ReadRequest)request);
        } else if (request instanceof WriteRequest) {
            command = this.factory.createWriteCommand((WriteRequest)request);
        } else if (request instanceof RandomWriteRequest) {
            command = this.factory.createRandomWriteCommand((RandomWriteRequest)request);
        } else if (request instanceof RandomReadRequest) {
            command = this.factory.createRandomReadCommand((RandomReadRequest)request);
        } else {
            throw new IllegalArgumentException("Unsupported request type");
        }
        return this.factory.createFrame(header, command);
    }

    @Override
    public void close() throws IOException {
        this.handler.close();
    }

    public static class DefaultBuilder
    implements SlmpClient.Builder {
        private Protocol protocol;
        private String host;
        private int port;
        private Integer timeout;
        private SlmpFactory factory;
        private StreamTransport streamTransport;
        private DatagramTransport datagramTransport;

        @Override
        public SlmpClient.Builder udp(String host, int port) {
            this.protocol = Protocol.UDP;
            this.host = host;
            this.port = port;
            return this;
        }

        @Override
        public SlmpClient.Builder tcp(String host, int port) {
            this.protocol = Protocol.TCP;
            this.host = host;
            this.port = port;
            return this;
        }

        @Override
        public SlmpClient.Builder transport(StreamTransport transport) {
            this.protocol = Protocol.TCP;
            this.streamTransport = transport;
            return this;
        }

        @Override
        public SlmpClient.Builder transport(DatagramTransport transport) {
            this.protocol = Protocol.UDP;
            this.datagramTransport = transport;
            return this;
        }

        @Override
        public SlmpClient.Builder timeout(int timeout) {
            if (timeout < 0) {
                throw new IllegalArgumentException("Timeout cannot be negative");
            }
            this.timeout = timeout;
            return this;
        }

        @Override
        public SlmpClient.Builder factory(SlmpFactory factory) {
            this.factory = factory;
            return this;
        }

        @Override
        public SlmpClient build() {
            Objects.requireNonNull(this.protocol, "Protocol (UDP or TCP) must be specified.");
            Objects.requireNonNull(this.factory, "Factory must be specified.");
            try {
                ProtocolHandler handler;
                SlmpFrameSerializer serializer = this.factory.createSerializer();
                SlmpResponseSizeCalculator sizeCalculator = this.factory.createResponseSizeCalculator();
                if (this.protocol == Protocol.UDP) {
                    Objects.requireNonNull(this.host, "Host must be specified for UDP.");
                    DatagramTransport transport = this.datagramTransport;
                    if (transport == null) {
                        Objects.requireNonNull(this.timeout, "Timeout must be specified if no transport is provided.");
                        transport = new SyncUdpTransport(this.timeout);
                    }
                    InetSocketAddress address = new InetSocketAddress(this.host, this.port);
                    handler = new UdpProtocolHandler(transport, serializer, sizeCalculator, address);
                } else if (this.protocol == Protocol.TCP) {
                    StreamTransport transport = this.streamTransport;
                    if (transport == null) {
                        Objects.requireNonNull(this.host, "Host must be specified if no transport is provided.");
                        Objects.requireNonNull(this.timeout, "Timeout must be specified if no transport is provided.");
                        InetSocketAddress address = new InetSocketAddress(this.host, this.port);
                        transport = new SyncTcpTransport(address, (int)this.timeout);
                    }
                    handler = new TcpProtocolHandler(transport, serializer, sizeCalculator);
                } else {
                    throw new IllegalStateException("Unsupported protocol: " + String.valueOf((Object)this.protocol));
                }
                return new DefaultSlmpClient(handler, this.factory);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        private static enum Protocol {
            UDP,
            TCP;

        }
    }
}

