/*
 * Decompiled with CFR 0.152.
 */
package plc.slmp.byteformatutility.parser;

import plc.slmp.byteformatutility.common.FormatSpec;
import plc.slmp.byteformatutility.parser.ByteParseStrategy;

public class UnsignedIntegerParseStrategy
implements ByteParseStrategy {
    @Override
    public Object parse(byte[] bytes, FormatSpec spec) {
        if (bytes.length <= 0 || bytes.length > 8) {
            throw new IllegalArgumentException("Invalid byte length for unsigned integer conversion: " + bytes.length);
        }
        long unsignedValue = 0L;
        if (spec.endian() == FormatSpec.Endian.LITTLE) {
            for (int i = 0; i < bytes.length; ++i) {
                unsignedValue |= ((long)bytes[i] & 0xFFL) << i * 8;
            }
        } else {
            for (byte b : bytes) {
                unsignedValue = unsignedValue << 8 | (long)b & 0xFFL;
            }
        }
        if (bytes.length < 4) {
            return (int)unsignedValue;
        }
        return unsignedValue;
    }
}

