/*
 * Decompiled with CFR 0.152.
 */
package plc.slmp.byteformatutility.parser;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import plc.slmp.byteformatutility.common.FormatSpec;
import plc.slmp.byteformatutility.parser.ByteParseStrategy;

public class SignedIntegerParseStrategy
implements ByteParseStrategy {
    @Override
    public Object parse(byte[] bytes, FormatSpec spec) {
        ByteOrder order;
        if (bytes.length <= 0 || bytes.length > 8) {
            throw new IllegalArgumentException("Invalid byte length for integer conversion: " + bytes.length);
        }
        ByteOrder byteOrder = order = spec.endian() == FormatSpec.Endian.LITTLE ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
        if (bytes.length <= 4) {
            return this.convertToInt(bytes, order);
        }
        return this.convertToLong(bytes, order);
    }

    private int convertToInt(byte[] bytes, ByteOrder order) {
        ByteBuffer buffer = ByteBuffer.allocate(4).order(order);
        if (order == ByteOrder.BIG_ENDIAN) {
            buffer.position(4 - bytes.length);
            buffer.put(bytes);
        } else {
            buffer.put(bytes);
        }
        buffer.rewind();
        return buffer.getInt();
    }

    private long convertToLong(byte[] bytes, ByteOrder order) {
        ByteBuffer buffer = ByteBuffer.allocate(8).order(order);
        if (order == ByteOrder.BIG_ENDIAN) {
            buffer.position(8 - bytes.length);
            buffer.put(bytes);
        } else {
            buffer.put(bytes);
        }
        buffer.rewind();
        return buffer.getLong();
    }
}

