/*
 * Decompiled with CFR 0.152.
 */
package plc.slmp.byteformatutility.parser;

import plc.slmp.byteformatutility.common.FormatSpec;
import plc.slmp.byteformatutility.parser.AsciiParseStrategy;
import plc.slmp.byteformatutility.parser.BinaryStringParseStrategy;
import plc.slmp.byteformatutility.parser.ByteParseStrategy;
import plc.slmp.byteformatutility.parser.HexParseStrategy;
import plc.slmp.byteformatutility.parser.SignedIntegerParseStrategy;
import plc.slmp.byteformatutility.parser.UnsignedIntegerParseStrategy;

public final class ParseStrategyFactory {
    private ParseStrategyFactory() {
    }

    public static ByteParseStrategy getStrategy(FormatSpec.FormatType type) {
        return switch (type) {
            case FormatSpec.FormatType.ASCII -> new AsciiParseStrategy();
            case FormatSpec.FormatType.HEX -> new HexParseStrategy();
            case FormatSpec.FormatType.BINARY_STRING -> new BinaryStringParseStrategy();
            case FormatSpec.FormatType.SIGNED_INTEGER -> new SignedIntegerParseStrategy();
            case FormatSpec.FormatType.UNSIGNED_INTEGER -> new UnsignedIntegerParseStrategy();
            default -> throw new IllegalArgumentException("Unsupported format type for parsing: " + String.valueOf((Object)type));
        };
    }
}

