/*
 * Decompiled with CFR 0.152.
 */
package plc.slmp.byteformatutility.formatter;

import java.nio.charset.StandardCharsets;
import plc.slmp.byteformatutility.common.FormatSpec;
import plc.slmp.byteformatutility.formatter.ByteTransformStrategy;

public class HexTransform
implements ByteTransformStrategy {
    @Override
    public byte[] transform(Object value, FormatSpec spec) {
        if (!(value instanceof Number)) {
            throw new IllegalArgumentException("HexTransform supports only Number type, but got: " + value.getClass().getName());
        }
        Number numValue = (Number)value;
        if (spec.length() <= 0) {
            throw new IllegalArgumentException("Specifier length must be positive, but was " + spec.length());
        }
        String formatString = "%0" + spec.length() + "X";
        String hexString = String.format(formatString, numValue);
        return hexString.getBytes(StandardCharsets.US_ASCII);
    }
}

