/*
 * Decompiled with CFR 0.152.
 */
package plc.slmp.byteformatutility.formatter;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import plc.slmp.byteformatutility.common.FormatSpec;
import plc.slmp.byteformatutility.formatter.ByteTransformStrategy;

public class BinaryTransform
implements ByteTransformStrategy {
    @Override
    public byte[] transform(Object value, FormatSpec spec) {
        if (spec.length() <= 0) {
            throw new IllegalArgumentException("Specifier length for binary format must be positive, but was " + spec.length());
        }
        if (value instanceof byte[]) {
            byte[] byteArray = (byte[])value;
            if (byteArray.length != spec.length()) {
                throw new IllegalArgumentException("Byte array length mismatch: expected " + spec.length() + ", got " + byteArray.length);
            }
            return byteArray;
        }
        if (value instanceof int[]) {
            int[] intArray = (int[])value;
            return this.convertIntArrayToBytes(intArray, spec.length(), spec.endian());
        }
        if (value instanceof Number) {
            return this.convertNumericToBytes(value, spec.length(), spec.endian());
        }
        throw new IllegalArgumentException("BinaryTransform supports only Number, int[], and byte[] types, but got: " + value.getClass().getName());
    }

    private byte[] convertNumericToBytes(Object value, int length, FormatSpec.Endian endian) {
        byte[] fullBytes;
        int typeSize;
        ByteOrder order;
        ByteOrder byteOrder = order = endian == FormatSpec.Endian.LITTLE ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
        if (value instanceof Integer) {
            Integer intVal = (Integer)value;
            typeSize = 4;
            ByteBuffer buffer = ByteBuffer.allocate(typeSize).order(order);
            buffer.putInt(intVal);
            fullBytes = buffer.array();
        } else if (value instanceof Short) {
            Short shortVal = (Short)value;
            typeSize = 2;
            ByteBuffer buffer = ByteBuffer.allocate(typeSize).order(order);
            buffer.putShort(shortVal);
            fullBytes = buffer.array();
        } else if (value instanceof Long) {
            Long longVal = (Long)value;
            typeSize = 8;
            ByteBuffer buffer = ByteBuffer.allocate(typeSize).order(order);
            buffer.putLong(longVal);
            fullBytes = buffer.array();
        } else if (value instanceof Float) {
            Float floatVal = (Float)value;
            typeSize = 4;
            ByteBuffer buffer = ByteBuffer.allocate(typeSize).order(order);
            buffer.putFloat(floatVal.floatValue());
            fullBytes = buffer.array();
        } else if (value instanceof Double) {
            Double doubleVal = (Double)value;
            typeSize = 8;
            ByteBuffer buffer = ByteBuffer.allocate(typeSize).order(order);
            buffer.putDouble(doubleVal);
            fullBytes = buffer.array();
        } else {
            throw new IllegalArgumentException("Unsupported numeric type: " + String.valueOf(value.getClass()));
        }
        if (length < typeSize) {
            if (endian == FormatSpec.Endian.BIG) {
                return Arrays.copyOfRange(fullBytes, typeSize - length, typeSize);
            }
            return Arrays.copyOf(fullBytes, length);
        }
        byte[] padded = new byte[length];
        if (endian == FormatSpec.Endian.BIG) {
            System.arraycopy(fullBytes, 0, padded, length - typeSize, typeSize);
        } else {
            System.arraycopy(fullBytes, 0, padded, 0, typeSize);
        }
        return padded;
    }

    private byte[] convertIntArrayToBytes(int[] value, int length, FormatSpec.Endian endian) {
        if (value.length * 2 != length) {
            throw new IllegalArgumentException("Int array length mismatch: expected " + length + " bytes, but array converts to " + value.length * 2 + " bytes.");
        }
        ByteOrder order = endian == FormatSpec.Endian.LITTLE ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
        ByteBuffer buffer = ByteBuffer.allocate(length).order(order);
        for (int val : value) {
            buffer.putShort((short)val);
        }
        return buffer.array();
    }
}

