/*
 * Decompiled with CFR 0.152.
 */
package plc.slmp.byteformatutility.formatter;

import java.nio.charset.StandardCharsets;
import plc.slmp.byteformatutility.common.FormatSpec;
import plc.slmp.byteformatutility.formatter.ByteTransformStrategy;

public class AsciiTransform
implements ByteTransformStrategy {
    @Override
    public byte[] transform(Object value, FormatSpec spec) {
        if (!(value instanceof String)) {
            throw new IllegalArgumentException("AsciiTransform supports only String type, but got: " + value.getClass().getName());
        }
        String strValue = (String)value;
        if (spec.length() <= 0) {
            throw new IllegalArgumentException("Specifier length for ASCII format must be positive, but was " + spec.length());
        }
        byte[] asciiBytes = strValue.getBytes(StandardCharsets.US_ASCII);
        if (asciiBytes.length != spec.length()) {
            throw new IllegalArgumentException("String length in bytes does not match format specifier length. Expected: " + spec.length() + ", Got: " + asciiBytes.length);
        }
        return asciiBytes;
    }
}

