/*
 * Decompiled with CFR 0.152.
 */
package plc.slmp.byteformatutility.common;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import plc.slmp.byteformatutility.common.FormatSpec;

public final class FormatParser {
    private static final Pattern PATTERN = Pattern.compile("%(\\d+)([buhaiS])([BL])?");
    private static final Map<String, List<FormatSpec>> CACHE = new HashMap<String, List<FormatSpec>>();
    private static final int GROUP_LENGTH = 1;
    private static final int GROUP_TYPE = 2;
    private static final int GROUP_ENDIAN = 3;

    private FormatParser() {
    }

    public static List<FormatSpec> parse(String format) {
        return CACHE.computeIfAbsent(format, FormatParser::parseFormat);
    }

    private static List<FormatSpec> parseFormat(String format) {
        ArrayList<FormatSpec> specs = new ArrayList<FormatSpec>();
        Matcher matcher = PATTERN.matcher(format);
        while (matcher.find()) {
            int length = Integer.parseInt(matcher.group(1));
            char typeChar = matcher.group(2).charAt(0);
            String endianFlag = matcher.group(3);
            FormatSpec.FormatType type = switch (typeChar) {
                case 'b' -> FormatSpec.FormatType.BINARY;
                case 'u' -> FormatSpec.FormatType.UNSIGNED_INTEGER;
                case 'i' -> FormatSpec.FormatType.SIGNED_INTEGER;
                case 'S' -> FormatSpec.FormatType.BINARY_STRING;
                case 'h' -> FormatSpec.FormatType.HEX;
                case 'a' -> FormatSpec.FormatType.ASCII;
                default -> throw new IllegalArgumentException("Unknown type: " + typeChar);
            };
            FormatSpec.Endian endian = "L".equals(endianFlag) ? FormatSpec.Endian.LITTLE : FormatSpec.Endian.BIG;
            specs.add(new FormatSpec(length, type, endian));
        }
        return specs;
    }
}

