/*
 * Decompiled with CFR 0.152.
 */
package plc.slmp.byteformatutility;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import plc.slmp.byteformatutility.common.FormatParser;
import plc.slmp.byteformatutility.common.FormatSpec;
import plc.slmp.byteformatutility.parser.ByteParseStrategy;
import plc.slmp.byteformatutility.parser.ParseStrategyFactory;

final class CustomByteParser {
    private CustomByteParser() {
    }

    static List<Object> parse(String format, byte[] input) {
        ArrayList<Object> result = new ArrayList<Object>();
        List<FormatSpec> specs = FormatParser.parse(format);
        int totalLength = specs.stream().mapToInt(FormatSpec::length).sum();
        if (input.length < totalLength) {
            throw new IllegalArgumentException(String.format("Input byte array is too short. Expected at least %d bytes, but got %d.", totalLength, input.length));
        }
        int currentIndex = 0;
        for (FormatSpec spec : specs) {
            int length = spec.length();
            byte[] segment = Arrays.copyOfRange(input, currentIndex, currentIndex + length);
            ByteParseStrategy strategy = ParseStrategyFactory.getStrategy(spec.type());
            Object parsedValue = strategy.parse(segment, spec);
            result.add(parsedValue);
            currentIndex += length;
        }
        return result;
    }
}

