/*
 * Decompiled with CFR 0.152.
 */
package plc.slmp.byteformatutility;

import java.util.ArrayList;
import java.util.List;
import plc.slmp.byteformatutility.common.FormatParser;
import plc.slmp.byteformatutility.common.FormatSpec;
import plc.slmp.byteformatutility.formatter.ByteTransformStrategy;
import plc.slmp.byteformatutility.formatter.TransformFactory;

final class CustomByteFormatter {
    private CustomByteFormatter() {
    }

    static byte[] formatToBytes(String format, Object ... args) {
        ArrayList<Byte> output = new ArrayList<Byte>();
        List<FormatSpec> specs = FormatParser.parse(format);
        if (specs.size() != args.length) {
            throw new IllegalArgumentException("Number of format specifiers (" + specs.size() + ") does not match number of arguments (" + args.length + ")");
        }
        for (int i = 0; i < specs.size(); ++i) {
            byte[] transformed;
            FormatSpec spec = specs.get(i);
            Object arg = args[i];
            ByteTransformStrategy strategy = TransformFactory.getStrategy(spec.type());
            for (byte b : transformed = strategy.transform(arg, spec)) {
                output.add(b);
            }
        }
        byte[] result = new byte[output.size()];
        for (int i = 0; i < output.size(); ++i) {
            result[i] = (Byte)output.get(i);
        }
        return result;
    }
}

